/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.mixin.create;

import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.content.fluids.potion.PotionMixingRecipes;
import com.simibubi.create.content.kinetics.mixer.MechanicalMixerBlockEntity;
import com.simibubi.create.content.kinetics.mixer.MixingRecipe;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinOperatingBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import plus.dragons.createdragonsplus.common.registry.CDPFluids;
import plus.dragons.createdragonsplus.config.CDPConfig;

@Mixin(value={MechanicalMixerBlockEntity.class})
public abstract class MechanicalMixerBlockEntityMixin
extends BasinOperatingBlockEntity {
    public MechanicalMixerBlockEntityMixin(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Inject(method={"getMatchingRecipes"}, at={@At(value="FIELD", ordinal=0, target="Lcom/simibubi/create/content/kinetics/mixer/MechanicalMixerBlockEntity;level:Lnet/minecraft/world/level/Level;")})
    private void getMatchingRecipes$checkDragonBreathFluid(CallbackInfoReturnable<List<Recipe<?>>> cir, @Local BasinBlockEntity basin, @Local List<Recipe<?>> matchingRecipes) {
        assert (this.level != null);
        if (CDPConfig.features().generateAutomaticBrewingRecipeForDragonBreathFluid.get().booleanValue()) {
            IFluidHandler tanks = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, basin.getBlockPos(), null);
            if (tanks == null) {
                return;
            }
            for (int i = 0; i < tanks.getTanks(); ++i) {
                FluidStack fluid = tanks.getFluidInTank(i);
                if (!fluid.is(CDPFluids.COMMON_TAGS.dragonBreath)) continue;
                List recipes = (List)PotionMixingRecipes.sortRecipesByItem((Level)this.level).get(Items.DRAGON_BREATH);
                if (recipes == null) {
                    return;
                }
                for (MixingRecipe recipe : recipes) {
                    if (!this.matchBasinRecipe((Recipe)recipe)) continue;
                    matchingRecipes.add((Recipe<?>)recipe);
                }
                break;
            }
        }
    }
}

